<?php

class GalaxPaySubscriptionStatus
{

    private $container;

    public function __construct(GalaxPaySettings $container)
    {
        $this->container = $container;
        add_action('woocommerce_subscription_status_cancelled', array(&$this, 'cancelStatus'));
        add_action('woocommerce_subscription_status_expired', array(&$this, 'cancelStatus'));
        add_action('woocommerce_subscription_status_pending-cancel', array(&$this, 'cancelStatus'));
    }

    public function cancelStatus($wcSubscription)
    {
        if (defined('IS_WEBHOOK') || defined('IS_PROCESS_PAYMENT')) {
            return;
        }
        $idBill = $this->getBillIdBySubscription($wcSubscription);
        $this->container->api->cancelSubscription($idBill, 'galaxPayId');
        $wcSubscription->add_order_note('Assinatura #'.$idBill.' cancelada no Galax Pay.');
    }

    private function getBillIdBySubscription($subscription)
    {
	$orderId = end($subscription->get_related_orders());
        return end(get_post_meta($orderId, 'galaxPayBill'));
    }
}
