<?php



class GalaxPaySettings extends WC_Settings_API

{



    public $dependency;

    private $debug;

    public $api;

    public $logger;

    public $woocommerce;

    public $activeIntegrations;



    public function __construct()

    {

        $this->setEnvironmentConstants();

        $this->token = sanitize_file_name(wp_hash(GALAX_IDENTIFIER));

        $this->init_form_fields();

        $this->init_settings();

        $this->initializeObjects();

        add_filter('woocommerce_payment_gateways', array(&$this, 'add_gateway'));

        $this->appendAdminSettings();

        $this->appendPaymentSettings();
    }



    private function appendPaymentSettings()

    {

        if (!empty($this->getGalaxId()) && !empty($this->getGalaxHash())) {

            $this->activeIntegrations = $this->api->getIntegrationsActiveInAccount();
        }
    }



    private function initializeObjects()

    {

        global $woocommerce;

        $this->debug = true;

        if (!empty($this->getGalaxId()) && !empty($this->getGalaxHash())) {

            $this->api = new GalaxPayApi($this->getGalaxId(), $this->getGalaxHash(), false, $this->logger);

            $this->logger = new GalaxPayLogger(GALAX_IDENTIFIER, $this->debug);

            $this->dependency = new GalaxPayDependencies();

            $this->woocommerce = $woocommerce;
        }
    }



    private function setEnvironmentConstants()

    {

        define('GALAXPAY_AMBIENTE', 'production');

        define('GALAXPAY_URL_BASE', 'https://app.galaxpay.com.br/');
    }



    public function get_api_key()

    {

        return;
    }



    private function appendAdminSettings()

    {

        if (is_admin()) {

            add_filter('woocommerce_settings_tabs_array', array(&$this, 'add_settings_tab'), 50);

            add_action('woocommerce_settings_tabs_settings_galax_pay', array(&$this, 'settings_tab'));

            add_action('woocommerce_update_options_settings_galax_pay', array(&$this, 'process_admin_options'));
        }
    }



    public function get_post_data()

    {

        $post = parent::get_post_data();

        $diff = false;

        $this->init_settings();



        if ($post['woocommerce__galaxHash'] != $this->settings['galaxHash']) {

            $diff = true;
        }

        if ($post['woocommerce__galaxId'] != $this->settings['galaxId']) {

            $diff = true;
        }

        if ($post['woocommerce__galaxTokenWebhook'] == '' || $diff) {
            
            $this->checkObject($post);
            $webhook = $this->api->setWebhookUrl($this->getSiteUrl());
            
            $this->settings['galaxTokenWebhook'] = $webhook['confirmHash'];

            $post['woocommerce__galaxTokenWebhook'] = $this->settings['galaxTokenWebhook'];
        }

        return $post;
    }



    public static function add_settings_tab($settings_tabs)

    {



        $settings_tabs['settings_galax_pay'] = __('Galax Pay', GALAX_IDENTIFIER);

        return $settings_tabs;
    }



    public function settings_tab()

    {

        $this->get_template('admin-settings.html.php', array('settings' => $this));
    }



    public function getSiteUrl()

    {

        return sprintf('%s/wc-api/%s', get_site_url(), GalaxPayWebhooks::WC_API_CALLBACK);
    }



    public function init_form_fields()

    {

        $this->form_fields = array(

            'galaxId' => array(

                'title' => __('Galax ID'),

                'type' => 'text',

                'description' => __('GalaxID, localizado no módulo de Webservice. <a href="' . GALAXPAY_URL_BASE . 'informacao-modulo/webservice/config" target="_blank">Clique aqui</a> para visualizar.'),

                'default' => '',

            ),

            'galaxHash' => array(

                'title' => __('Galax Hash'),

                'type' => 'text',

                'description' => __('GalaxHash, localizado no módulo de Webservice. <a href="' . GALAXPAY_URL_BASE . 'informacao-modulo/webservice/config" target="_blank">Clique aqui</a> para visualizar.'),

                'default' => '',

            ),

            'galaxTokenWebhook' => array(

                'title' => __('Token do Webhook'),

                'type' => 'text',

                'custom_attributes' => array('readonly' => 'readonly'),

                'description' => __('Token Webhook, localizado no módulo de Webservice. Ele é preenchido automaticamente ao salvar.'),

                'default' => '',

            ),
            
            'galaxPayPaymentStatus' => array(

                'title' => __('Status do pedido ao ser pago'),

                'type' => 'select',

                'custom_attributes' => array('readonly' => 'readonly'),

                'description' => __('Status que o pedido ficará quando o pagamento do mesmo ser realizado.'),

                'default' => 'completed',
                
                'options' => array(
                    'completed' => 'Concluída',
                    'processing' => 'Em processamento'
                )

            ),


            
            
            
            
        );
        
    }



    public function getGalaxId()

    {

        return $this->settings['galaxId'];
    }



    public function getGalaxTokenWebhook()

    {

        return $this->settings['galaxTokenWebhook'];
    }



    public function getGalaxHash()

    {

        return $this->settings['galaxHash'];
    }

    public function getTimeDeadlinePix()

    {

        $credit = new GalaxPayPix($this);
        return $credit->get_option('tempoValidadePix');
    }

    public function getTypeDeadlinePix()

    {
        $credit = new GalaxPayPix($this);
        return $credit->get_option('tempoTipoValidadePix');
    }


    public function getTimeDeadlinePixSubs()

    {
        $credit = new GalaxPayPix($this);
        return $credit->get_option('tempoValidadePixSubs');
    }

    public function getTypeDeadlinePixSubs()

    {

        return 'days';
    }




    public function getQuantityDaysBeforeSale()

    {
        $credit = new GalaxPayBoleto($this);
        return $credit->get_option('daysAfterBoletoDueDate');
    }

    public function getInstallmentsFee(){
        $credit = new GalaxPayCreditCard($this);
        return $credit->get_option('installments_fee');
    }

    public function getAdditionalInfoBoleto()

    {
        $credit = new GalaxPayBoleto($this);
        return $credit->get_option('infoBoleto');
    }

    public function getReturnStatusSubscription()

    {

        return GalaxPayDefaultStatus::getOrderDefaultStatus();
    }



    public function get_shipping_and_tax_config()

    {

        return $this->settings['shipping_and_tax_config'] == 'yes';
    }



    public function cycles_to_discount()

    {

        if (!empty($this->settings['discounts_to_cycles'])) {

            return (int) $this->settings['discounts_to_cycles'];
        }

        return null;
    }



    public function get_is_active_sandbox()

    {

        return false;
    }



    public function check_ssl()

    {

        return true;
    }



    public static function getSupports()

    {

        return  array(

            'subscriptions',

            'products',

            'subscription_payment_method_change',

            'subscription_cancellation',
            
            'subscription_amount_changes',
            
            'subscription_reactivation',
            
            'subscription_suspension',

            /* 

            'subscription_reactivation',

            'subscription_suspension',

            'subscription_amount_changes',

           

            'subscription_payment_method_change_customer',

            'subscription_payment_method_change_admin',*/

            //  'subscription_date_changes',

            'multiple_subscriptions',

            // 'refunds',

            //   'pre-orders'

        );
    }



    public function add_gateway($methods)

    {

        $map = array(

            
            'pix' => 'GalaxPayPix',

            'boleto' => 'GalaxPayBoleto',

            'credit' => 'GalaxPayCreditCard',

        );

        foreach ($this->activeIntegrations as $active) {

            $class = $map[$active['id']];

            if (!class_exists($class)) {

                throw new \Exception('class not found ' . $class . ' - ' . $active['id']);
            }

            $bankSlip = new $class($this);

            if (is_checkout()) {

                if ($bankSlip->enabled == 'yes') {

                    $methods[] = $bankSlip;
                }
            } else {

                $methods[] = $bankSlip;
            }
        }

        return $methods;
    }



    public function get_template($name, $args = array())

    {

        wc_get_template($name, $args, '', sprintf('%s/../%s', dirname(__FILE__), GalaxPayWooCommerce::VIEWS_DIR));
    }



    public function add_script($path, $dependencies = array())

    {

        wp_enqueue_script('galax-pay-checkout', GalaxPayWooCommerce::generate_assets_url($path), $dependencies);
    }



    public function allow_switching_is_activated()

    {

        if (get_option('woocommerce_subscriptions_allow_switching') == 'no') {

            return;
        }

        $this->get_template('allow_switching_is_activated.html.php');
    }
    
    private function checkObject($post)
    {
        if (is_null($this->api)) {
            if (empty($this->settings['galaxId'])) {
                $this->settings['galaxId'] = $post['woocommerce__galaxId'];
            }
            if (empty($this->settings['galaxHash'])) {
                $this->settings['galaxHash'] = $post['woocommerce__galaxHash'];
            }
            $this->initializeObjects();
        }
    }
    
}