<?php

trait GalaxPayCharge
{

    public function processSinglePayment($type)
    {

        $response = $this->createIndividualCharge($type);

        $bill = $response['Charge'];

        if ($response['type'] == false) {

            $message = $response['error']['message'];

            $this->container->api->cancelCharge($bill['galaxPayId']);

            $this->order->update_status('cancelled', __($message, GALAX_IDENTIFIER));

            $this->abort(__($message, GALAX_IDENTIFIER), true);
        }



        add_post_meta($this->order->id, 'galaxPayBill', $bill['galaxPayId']);

        add_post_meta($this->order->id, 'galaxCustomerId', $bill['Customer']['galaxPayId']);

        return $this->finishSinglePayment($bill);
    }

    private function chargeExistsOnGalaxPay($id)
    {

        $bill = $this->container->api->getChargeByMyId($id);

        if ($bill['totalQtdFoundInPage'] == 1) {

            return true;
        }

        return false;
    }

    private function retryPaymentCharge()
    {

        $body = $this->getCommonBody('charge');

        $bill = $this->container->api->retryCharge($this->order->id, $body);

        return $bill;
    }

    protected function createIndividualCharge()
    {

        $body = $this->getCommonBody('charge');
        
        if ($this->chargeExistsOnGalaxPay($this->order->id)) {

            $response = $this->retryPaymentCharge();
        } else {


            $bill = $this->container->api->createCharge($body);
        }



        if (!$bill) {

            $this->container->logger->log(sprintf('Erro no pagamento do pedido.', $this->order->id));

            $message = sprintf(__('Pagamento Falhou.', GALAX_IDENTIFIER), $this->container->api->last_error);

            $this->order->update_status('failed', $message);

            throw new Exception($message);
        }

        WC()->session->__unset('current_payment_profile');

        WC()->session->__unset('current_customer');

        return $bill;
    }

    protected function finishSinglePayment($bill)
    {

        $this->container->woocommerce->cart->empty_cart();

        $statusPayment = $bill['Transactions'][0]['status'];

        $status = $this->container->getReturnStatusSubscription();

        if ($statusPayment == 'captured') {

            $status_message = __('O Pagamento foi realizado com sucesso pelo Galax Pay.', GALAX_IDENTIFIER);
        } else if ($statusPayment == 'denied') {

            $status = 'cancelled';

            $status_message = __('Pagamento negado.', GALAX_IDENTIFIER);
        } else {

            $data_to_log = sprintf('Aguardando pagamento do pedido %s pelo Galax Pay.', $this->order->id);

            $status_message = __('Aguardando pagamento do pedido.', GALAX_IDENTIFIER);

            $status = 'pending';

            $this->container->logger->log($data_to_log);
        }

        $this->order->update_status($status, $status_message);

        return array(
            'result' => 'success',
            'redirect' => $this->order->get_checkout_order_received_url(),
        );
    }

}
