<?php

class GalaxPayPayment
{

    protected $order;
    public $typePayment, $gateway;
    protected $container;

    use GalaxPayGetInfoOrder;
    use GalaxPaySubscription;
    use GalaxPayCharge;

    function __construct(WC_Order $order, GalaxPayBaseGateway $gateway, GalaxPaySettings $container)
    {
        $this->order = $order;
        $this->gateway = $gateway;
        $this->container = $container;
    }

    public function abort($message, $throw_exception = false)
    {
        $this->container->logger->log($message);
        $this->order->add_order_note($message);
        $this->order->update_status('cancelled', $message);
        wc_add_notice($message, 'error');
        throw new \Exception($message);
    }

    public function process($type)
    {
        define('IS_PROCESS_PAYMENT', true);
        $types = [
            'galax-pay-credit-card' => 'card',
            'galax-pay-boleto' => 'boleto',
            'galax-pay-pix' => 'pix',
        ];
        $type = $types[$type];
        $this->typePayment = $type;
        $this->gateway = $this;
        if ($this->isSubscription()) {
            return $this->processSubscription();
        } else {
            return $this->processSinglePayment($this->typePayment);
        }
    }

}
